;;; 
;;; Virtual Disk Drive Project	- Sep 16, 2001 - EJR (in Austin)
;;;

;;; Main routine.

#include "vd.h"
#include "intrupt.h"
#include "serial.h"
#include "disk.h"
#include "hardware.h"
#include "sertrack.h"

	list p=16c74b,f=INHX32	; INHX32 required for config bits in file
	__config 0xFFB2		; xx11 1111 x011 0010
				;   Code protect = off (13-8,5,4)
				;   (not used) (7)
				;   Brown out timer = off (6)
				;   /Power up timer = on (3)
				;   Watchdog = off (2)
				;   Clock = HS (1,0)
	Title "vd.asm"
	
;;;
;;; This routine exports the following symbols
;;; 
 	global	Start
	global	DiskTable
	global	GCR6x2Map
	global	GCR5x3Map

PROG1	CODE
	
;;;*******************************************************************
;;; NAME:	DiskTable()
;;;
;;; DESCR:	Disk mapping table.  It was put here to ensure that it
;;;		stayed within a single code page, to make calling it
;;;		easier.
;;;
;;; ARGS:	the disk offset was placed in DTOFFSET
;;;
;;; RETURNS:	the disk pointer is in W
;;;
;;; NOTES:	- have minimal race condition here, it is possible that the
;;; 		  signal changes on the disk select lines during the few cycles
;;;		  that we spend checking for them.
;;;		- 4 cycles chewed up (including return) (+2 for "call")
;;;		- NOTE:	10/1/04 - 5 cycles are actually used, the addwf
;;;		  modifies the PCL, causing it to take 2 cycles
;;;*******************************************************************
DiskTable:
	movf	DTOFFSET,W	; (0)
	addwf	PCL		; (1)
	retlw	NULLDISK	; (2,3) 0,0
	retlw	DISK0		; (2,3) 0,1
	retlw	DISK1		; (2,3) 1,0
	retlw	DISK2		; (2,3) 1,1

;;;*******************************************************************
;;; GCR Tables used for encoding GCR.  These must be at the start of
;;; a 256-byte page so the "jump-table" nature won't blow up.
;;;*******************************************************************
;;;*******************************************************************
;;; NAME:	  GCR6x2Map()   and  GCR5x3Map()
;;;             * 64 entries *     * 32 entries *
;;;
;;; DESCR:	called to map 6/5 bits to an 8-bit value
;;;
;;; ARGS:	
;;;
;;; RETURNS:	
;;;
;;; NOTES:	- these routines MUST NOT cross a 256-byte boundary
;;;		  - and remember that it has 64 bytes
;;;		- takes 7 cycles (2 for call, 2 for "jump",
;;;			2 for return, and 1 for the mask)
;;;*******************************************************************
GCR6x2Map:
	andlw	0x3f		; (2)
	addwf	PCL		; (3)
	retlw	0x96		; (5)
	retlw	0x97		; (5)
	retlw	0x9A		; (5)
	retlw	0x9B		; (5)
	retlw	0x9D		; (5)
	retlw	0x9E		; (5)
	retlw	0x9F		; (5)
	retlw	0xA6		; (5)
	retlw	0xA7		; (5)
	retlw	0xAB		; (5)
	retlw	0xAC		; (5)
	retlw	0xAD		; (5)
	retlw	0xAE		; (5)
	retlw	0xAF		; (5)
	retlw	0xB2		; (5)
	retlw	0xB3		; (5)
	retlw	0xB4		; (5)
	retlw	0xB5		; (5)
	retlw	0xB6		; (5)
	retlw	0xB7		; (5)
	retlw	0xB9		; (5)
	retlw	0xBA		; (5)
	retlw	0xBB		; (5)
	retlw	0xBC		; (5)
	retlw	0xBD		; (5)
	retlw	0xBE		; (5)
	retlw	0xBF		; (5)
	retlw	0xCB		; (5)
	retlw	0xCD		; (5)
	retlw	0xCE		; (5)
	retlw	0xCF		; (5)
	retlw	0xD3		; (5)
	retlw	0xD6		; (5)
	retlw	0xD7		; (5)
	retlw	0xD9		; (5)
	retlw	0xDA		; (5)
	retlw	0xDB		; (5)
	retlw	0xDC		; (5)
	retlw	0xDD		; (5)
	retlw	0xDE		; (5)
	retlw	0xDF		; (5)
	retlw	0xE5		; (5)
	retlw	0xE6		; (5)
	retlw	0xE7		; (5)
	retlw	0xE9		; (5)
	retlw	0xEA		; (5)
	retlw	0xEB		; (5)
	retlw	0xEC		; (5)
	retlw	0xED		; (5)
	retlw	0xEE		; (5)
	retlw	0xEF		; (5)
	retlw	0xF2		; (5)
	retlw	0xF3		; (5)
	retlw	0xF4		; (5)
	retlw	0xF5		; (5)
	retlw	0xF6		; (5)
	retlw	0xF7		; (5)
	retlw	0xF9		; (5)
	retlw	0xFA		; (5)
	retlw	0xFB		; (5)
	retlw	0xFC		; (5)
	retlw	0xFD		; (5)
	retlw	0xFE		; (5)
	retlw	0xFF		; (5)
	
GCR5x3Map:
	andlw	0x1f		; (2)
	addwf	PCL		; (3)
	retlw	0xAB		; (5)
	retlw	0xAD		; (5)
	retlw	0xAE		; (5)
	retlw	0xAF		; (5)
	retlw	0xB5		; (5)
	retlw	0xB6		; (5)
	retlw	0xB7		; (5)
	retlw	0xBA		; (5)
	retlw	0xBB		; (5)
	retlw	0xBD		; (5)
	retlw	0xBE		; (5)
	retlw	0xBF		; (5)
	retlw	0xD6		; (5)
	retlw	0xD7		; (5)
	retlw	0xDA		; (5)
	retlw	0xDB		; (5)
	retlw	0xDD		; (5)
	retlw	0xDE		; (5)
	retlw	0xDF		; (5)
	retlw	0xEA		; (5)
	retlw	0xEB		; (5)
	retlw	0xED		; (5)
	retlw	0xEE		; (5)
	retlw	0xEF		; (5)
	retlw	0xF5		; (5)
	retlw	0xF6		; (5)
	retlw	0xF7		; (5)
	retlw	0xFA		; (5)
	retlw	0xFB		; (5)
	retlw	0xFD		; (5)
	retlw	0xFE		; (5)
	retlw	0xFF		; (5)

	
;;;*******************************************************************
;;; NAME:	Start()
;;;
;;; DESCR:	entry point for this thing
;;;
;;; ARGS:	
;;;
;;; RETURNS:	
;;;
;;; NOTES:	
;;;*******************************************************************
Start:
	call	HardwareSetup
	call	DiskSetSetup

	call	SerialSetup
	call	InterruptSetup

	bsf	RUNSTATE,STOPPING
	bsf	RUNSTATE,STOPPED  ; upon reset, go into stopped state

Loop:
	btfss	RUNSTATE,STOPPING  ; if not stopping (implies stopped too)
	call	Running		   ;  then we must be running

	btfsc	RUNSTATE,STOPPING
	bsf	RUNSTATE,STOPPED   ; got a stop command, indicate stopped

	goto	Loop
	
;;;*******************************************************************
;;; NAME:	Running()
;;;
;;; DESCR:	Called when running.  Checks head movement too.
;;;
;;; ARGS:	
;;;
;;; RETURNS:	
;;;
;;; NOTES:
;;;*******************************************************************
Running:
	DiskLineMap			; (0) get state of disk select
	call		DiskTable	; (7) afterthis, W has disk selection
	
	xorlw		NULLDISK	; (13) check to see if a disk was selected
	skpnz				; (14)
	return				; (15)

	xorlw		NULLDISK	; (16) get back to the selected disk
	
	;; W has the disk to activate

	call		DiskActivate	; and activate the disk

	;; so the given disk was activated, but it may not have been
	;; loaded from the PC, in this case, don't respond to that
	;; drive request!  This is done by checking for a NULLDISK.

	movlw		NULLDISK
	subwf		CURDISK,W
	skpnz				; don't do track in this case
	return

	movf		WRITEPROT
	skpz
	Raise		WPROTECT	; if non-zero WRITEPROT, turn on write-protect

	call		SerTrack	; send out the track
	Lower		TRACK0		; bring down track 0 line in any case
		
	Lower		WPROTECT	;  lower write protect in any case
	return
	
;;; =======================================================================
;;; =======================================================================

	END
